<?php 
namespace sms\jiansms;

use app\admin\lib\Plugin;

class JiansmsPlugin extends Plugin
{
    # 基础信息
    public $info = array(
        'name' => 'jiansms',
        'title' => '简信',
        'description' => '简信短信服务平台',
        'status' => 1,
        'author' => '小晨',
        'version' => '1.0',
        'help_url' => 'https://sms.losels.eu.org/',
    );

    # 插件安装
    public function install()
    {
        $smsTemplate = [];
        if (file_exists(__DIR__.'/config/smsTemplate.php')){
            $smsTemplate = require __DIR__.'/config/smsTemplate.php';
        }
        return $smsTemplate;
    }

    # 插件卸载
    public function uninstall()
    {
        return true;
    }

    # 后台页面创建模板时可用参数
    public function description()
    {
        return file_get_contents(__DIR__.'/config/description.html');
    }

    #获取国内模板
    public function getCnTemplate($params)
    {
        $data['status'] = 'success';
        $data['template']['template_status'] = 2;
        return $data;
    }

    #创建国内模板
    public function createCnTemplate($params)
    {
        $data['status'] = 'success';
        $data['template']['template_status'] = 2;
        return $data;
    }

    #修改国内模板
    public function putCnTemplate($params)
    {
        $data['status'] = 'success';
        $data['template']['template_status'] = 2;
        return $data;
    }

    #删除国内模板
    public function deleteCnTemplate($params)
    {
        $data['status'] = 'success';
        return $data;
    }

    #发送国内短信
    public function sendCnSms($params)
    {
        $content = $this->templateParam($params['content'], $params['templateParam']);
        $param['content'] = $this->templateSign($params['config']['sign']) . $content;
        $param['mobile'] = trim($params['mobile']);
        $resultTemplate = $this->APIHttpRequestCURL('cn', $param, $params['config']);
        
        if ($resultTemplate['status'] == 'success') {
            $data['status'] = 'success';
            $data['content'] = $content;
        } else {
            $data['status'] = 'error';
            $data['content'] = $content;
            $data['msg'] = $resultTemplate['msg'];
        }
        return $data;
    }

    private function APIHttpRequestCURL($sms_type = 'cn', $params, $config)
    {
        // 使用完整的API地址
        $api_url = 'https://sms.losels.eu.org/api/send.php';
        
        // 获取配置参数
        $api_key = isset($config['pass']) ? trim($config['pass']) : '';
        $phone = trim($params['mobile']);
        $message = trim($params['content']);
        
        // 验证必需参数
        if (empty($api_key)) {
            return ['status' => 'error', 'msg' => '配置错误: API密钥未设置'];
        }
        if (empty($phone)) {
            return ['status' => 'error', 'msg' => '手机号码不能为空'];
        }
        if (empty($message)) {
            return ['status' => 'error', 'msg' => '短信内容不能为空'];
        }
        
        // 准备请求参数 - 使用GET方式，参数通过查询字符串传递
        $query_params = http_build_query([
            'api_key' => $api_key,
            'phone' => $phone,
            'message' => $message
        ]);
        
        $full_url = $api_url . '?' . $query_params;
        
        // 使用cURL发送GET请求
        if (function_exists('curl_init')) {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $full_url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_TIMEOUT, 30);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36');
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
            
            $result = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            $error = curl_error($ch);
            curl_close($ch);
            
            if ($result === false) {
                return ['status' => 'error', 'msg' => 'cURL请求失败: ' . $error];
            }
            
            if ($httpCode !== 200) {
                return ['status' => 'error', 'msg' => 'HTTP错误代码: ' . $httpCode];
            }
        } else {
            // 如果cURL不可用，使用file_get_contents
            $context = stream_context_create([
                'http' => [
                    'method' => 'GET',
                    'timeout' => 30,
                    'ignore_errors' => true
                ],
                'ssl' => [
                    'verify_peer' => false,
                    'verify_peer_name' => false
                ]
            ]);
            
            $result = @file_get_contents($full_url, false, $context);
            if ($result === false) {
                return ['status' => 'error', 'msg' => '无法连接到API服务器'];
            }
        }
        
        // 解析JSON响应
        $response = json_decode($result, true);
        if (json_last_error() !== JSON_ERROR_NONE) {
            // 如果不是JSON格式，可能是HTML页面或其他错误
            if (strlen($result) > 200) {
                $result = substr($result, 0, 200) . '...';
            }
            return ['status' => 'error', 'msg' => 'API响应格式错误，返回内容: ' . $result];
        }
        
        // 处理API响应
        if (isset($response['success']) && $response['success'] === true) {
            return ['status' => 'success', 'msg' => $response['message'] ?? '短信发送成功'];
        } else {
            $code = $response['code'] ?? '-1';
            $errorMsg = $response['message'] ?? '未知错误';
            return ['status' => 'error', 'msg' => '简信API错误: ' . $errorMsg . ' (代码: ' . $code . ')'];
        }
    }

    private function templateParam($content, $templateParam)
    {
        foreach ($templateParam as $key => $para) {
            $content = str_replace('{' . $key . '}', $para, $content);
        }
        $content = preg_replace('/\\{.*?\\}/is', '', $content);
        return $content;
    }

    private function templateSign($sign)
    {
        $sign = str_replace('【', '', $sign);
        $sign = str_replace('】', '', $sign);
        $sign = '【' . $sign . '】';
        return $sign;
    }
}
